<?php

namespace AgeGate\Region\Submit;

class Redirect
{
    public function __construct()
    {
        add_filter('age_gate/success/redirect', [$this, 'redirect'], 10, 2);
        add_filter('allowed_redirect_hosts', [$this, 'hosts']);
    }

    public function redirect($url, $data)
    {
        $settings = get_option('wp_age_gate_regions', []);

        if (!empty($settings['region'][$data['age_gate']['region']]['redirect'])) {
            if ($settings['region'][$data['age_gate']['region']]['redirect'] !== 'custom') {
                return $settings['region'][$data['age_gate']['region']]['redirect'];
            } else {
                return $settings['region'][$data['age_gate']['region']]['custom_redirect'] ?? '';
            }
        }

        return $url;
    }

    /**
     * Add custom urls to redirect
     *
     * @param array $hosts
     * @return array
     */
    public function hosts($hosts = [])
    {
        $settings = get_option('wp_age_gate_regions', []);

        foreach ($settings['region'] ?? [] as $region) {
            if (!empty($region['custom_redirect'])) {
                $url = parse_url($region['custom_redirect']);
                $hosts[] = $url['host'] ?? '';
            }
        }

        $hosts = array_filter($hosts);
        return $hosts;
    }
}
